MODULE MessageModule
	USE FilesModule
	IMPLICIT NONE

	INTEGER, PARAMETER :: INCORRECTPARAMETERFILE = 1
	INTEGER, PARAMETER :: INCORRECTGENERALPARAMETERFILE = 2
	INTEGER, PARAMETER :: WRITEPARAMETERFILEERROR = 3
	INTEGER, PARAMETER :: WRITEGENERALPARAMETERFILEERROR = 4
	INTEGER, PARAMETER :: STARTERROR = 5
	INTEGER, PARAMETER :: FILENAMETOOLONG = 6
	INTEGER, PARAMETER :: FREQUENCYMATCH = 7
	INTEGER, PARAMETER :: DIALOGBOXERROR = 8

	CHARACTER (*), PARAMETER :: MessageText(8) = &
		["Parameter file could not be read correctly.\nMake sure it is a correct parameter file.\nThe values that are read correctly will be set."C, &
		"Parameter file "//TRIM(FN_parameters)// " could not be read correctly.\nMake sure it is a correct parameter file.\nProgram will try and continue."C, &
		"Could not write to file. Cochlea settings have not been saved\nMake sure the file is not write protected or in use by another program"C, &
		"Could not write cochlea settings to the file " // TRIM(FN_PARAMETERS) // ".\nMake sure the file is not write protected or in use by another program."C, &
		"Could not start cochlea2.exe.\nMake sure cochlea2.exe is in the current directory."C, &
		"File name may not exceed 127 characters.\nFile has not been saved"C, &
		"Audio signal will be resampled to match the internal computation frequency.\nThe internal computation frequency will be altererd also (at most 1%) to get an exact match."C, &
		"Could not display dialog box.\nProgram will be stopped"C]

	CHARACTER (*), PARAMETER :: MessageTitle(8) = &
		["Error reading parameter file"C, &
		"Error reading " // TRIM(FN_parameters) // ""C, &
		"Error writing parameter file"C, &
		"Error writing (" // TRIM(FN_PARAMETERS) // ")"C, &
		"Error starting cochlea2"C, &
		"File name too long"C, &
		"Matching frequencies"C, &
		"Error displaying dialog box"C]

END MODULE